<?php
session_start();
include 'conexao.php';

// ✅ Restringe o acesso apenas à Subdireção Pedagógica
if (!isset($_SESSION['usuario']) || $_SESSION['usuario']['perfil'] !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$msg = "";
$planos = [];

// ✅ Consulta para buscar TODOS os planos de aula
$sql = "SELECT * FROM upload ORDER BY data_upload DESC";
$result = $conn->query($sql);

if ($result) {
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $planos[] = $row;
        }
    } else {
        $msg = "Nenhum plano de aula encontrado.";
    }
} else {
    $msg = "Erro ao buscar dados do banco de dados: " . $conn->error;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar Planos de Aula</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f6f9; margin: 0; padding: 0; }
        header { background: #004085; color: #fff; padding: 15px; text-align: center; }
        .container { max-width: 900px; background: #fff; margin: 20px auto; padding: 20px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h2 { color: #004085; text-align: center; }
        .info-bar { background: #e9ecef; padding: 10px; border-radius: 6px; margin-bottom: 15px; text-align: center; }
        .lista-planos { margin-top: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; }
        th { background: #004085; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .msg { margin-top: 10px; text-align: center; font-weight: bold; color: red; }
    </style>
</head>
<body>

<header>
    <h1>📋 Painel de Planos de Aula (Subdireção Pedagógica)</h1>
</header>

<div class="container">
    <div class="info-bar">
        Bem-vindo, <b>Subdireção Pedagógica</b>. Aqui você pode visualizar todos os planos de aula enviados pelos professores.
    </div>

    <?php if ($msg) echo "<p class='msg'>$msg</p>"; ?>

    <div class="lista-planos">
        <table>
            <thead>
                <tr>
                    <th>Professor</th>
                    <th>Disciplina</th>
                    <th>Turma</th>
                    <th>Descrição</th>
                    <th>Arquivo</th>
                    <th>Data de Envio</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($planos as $plano): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($plano['nome_professor']); ?></td>
                        <td><?php echo htmlspecialchars($plano['disciplina']); ?></td>
                        <td><?php echo htmlspecialchars($plano['turma']); ?></td>
                        <td><?php echo htmlspecialchars($plano['descricao']); ?></td>
                        <td><a href="<?php echo htmlspecialchars($plano['caminho']); ?>" target="_blank">📥 Baixar</a></td>
                        <td><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($plano['data_upload']))); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>